/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
#include "ps_config.hpp"

cPropertySetConfig::cPropertySetConfig () :
m_line_end ( '\n' ),
m_assign ( '=' ),
m_key_start ( '[' ),
m_key_end ( ']' ),
m_info_start ( '#' ),
m_multi_value ( ';' ),
m_file_mode ( EXISTS_OVERWRITE_OR_CREATE ),
m_filename ( "filename" )
{
}

cPropertySetConfig::~cPropertySetConfig ()
{
}

char cPropertySetConfig::GetAssignSymbol () const
{
	return m_assign;
}

void cPropertySetConfig::SetAssignSymbol ( const char assign )
{
	m_assign = assign;
}

char cPropertySetConfig::GetKeyStartDelim () const
{
	return m_key_start;
}

void cPropertySetConfig::SetKeyStartDelim ( const char start )
{
	m_key_start = start;
}

char cPropertySetConfig::GetKeyEndDelim () const
{
	return m_key_end;
}

void cPropertySetConfig::SetKeyEndDelim ( const char end )
{
	m_key_end = end;
}

char cPropertySetConfig::GetLineEndDelim () const
{
	return m_line_end;
}

void cPropertySetConfig::SetLineEndDelim ( const char end )
{
	m_line_end = end;
}

char cPropertySetConfig::GetInfoStartDelim () const
{
	return m_info_start;
}

void cPropertySetConfig::SetInfoStartDelim ( const char start )
{
	m_info_start = start;
}

char cPropertySetConfig::GetMultiValueDelim () const
{
	return m_multi_value;
}

void cPropertySetConfig::SetMultiValueDelim ( const char multi )
{
	m_multi_value = multi;
}

cPropertySetConfig::eFileMode cPropertySetConfig::GetFileMode () const
{
	return m_file_mode;
}

void cPropertySetConfig::SetFileMode ( const eFileMode mode )
{
	switch ( mode )
	{
		case EXISTS_OVERWRITE_OR_CREATE:
		case EXISTS_OVERWRITE_OR_FAIL:
		case EXISTS_FAIL_OR_CREATE:			m_file_mode = mode; break;

		default: cInvalidFileMode e ( "Error: Invalid file mode found in cPropertySetConfig::SetFileMode ()" );
				 throw e;
	}
}

void cPropertySetConfig::SetFileName ( const string &filename )
{
	m_filename = filename;
}

string cPropertySetConfig::GetFileName () const
{
	return m_filename;
}

cPropertySetConfig::cInvalidFileMode::cInvalidFileMode ( string msg ) :
cPropertyException ( msg )
{
}

