/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
/*********************************************************************************************
*	Class:		cPropertySetConfig
*
*	Purpose:	A property set config file tracks the tokens used to parse a property set file.
*				
*	Notes:		
*
*	The tokens are as follows:
*	key string is <m_key_start> any text <m_key_end>
*	parameter string is <m_line_end> parameter name <m_assign>
*	value string is <m_assign> value <m_multi_value> value <m_multi_value> ... <m_line_end>
*	an information string is <m_info_start> any text <m_line_end>
*
*	the defaults:
*	m_info_start	= '#'
*	m_line_end		= '\n'
*	m_assign			= '='
*	m_key_start		= '['
*	m_key_end		= ']'
*	m_multi_value	= ';'
*
*	File Mode:
*	When a property set is opened, the rules are used to determine how
*	an existing file of the same name is handled
*
*	Author:	Robert Farrell
*	Email:	farrellr@accis.edu
*
*	History:
*	12/18/2001	Initial version.
*********************************************************************************************/
#ifndef _PROPERTY_SET_CONFIG_HPP
#define _PROPERTY_SET_CONFIG_HPP

#include "ps_exception.hpp"
#include <string>

using std::string;

class cPropertySetConfig
{
public:
	cPropertySetConfig ();
	virtual ~cPropertySetConfig ();

	enum eFileMode {	EXISTS_OVERWRITE_OR_CREATE,
						EXISTS_OVERWRITE_OR_FAIL,
						EXISTS_FAIL_OR_CREATE };

	// Exceptions
	class cInvalidFileMode;

	char	GetAssignSymbol () const;
	void	SetAssignSymbol ( const char assign );
	
	char	GetKeyStartDelim () const;
	void	SetKeyStartDelim ( const char start );
	
	char	GetKeyEndDelim () const;
	void	SetKeyEndDelim ( const char end );
	
	char	GetLineEndDelim () const;
	void	SetLineEndDelim ( const char end );

	char	GetInfoStartDelim () const;
	void	SetInfoStartDelim ( const char start );

	char	GetMultiValueDelim () const;
	void	SetMultiValueDelim ( const char multi );

	eFileMode	GetFileMode () const;
	void		SetFileMode ( const eFileMode mode );

	void		SetFileName ( const string &filename );
	string		GetFileName () const;

private:
	char		m_assign;
	char		m_key_start;
	char		m_key_end;
	char		m_line_end;
	char		m_info_start;
	char		m_multi_value;
	eFileMode	m_file_mode;
	string		m_filename;
};

class cPropertySetConfig::cInvalidFileMode : public cPropertyException
{
public:
	cInvalidFileMode ( string msg );
};
#endif // _PROPERTY_SET_CONFIG_HPP
