/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
#include "ps_multi_property.hpp"

cMultiProperty::cMultiProperty ( const cPropertyValue::eValueType type )
{
	// create a single value and default value
	AllocateValue ( type );
}

cMultiProperty::cMultiProperty ()
{
	// create a single value and default value
	AllocateValue ();
}

cMultiProperty::~cMultiProperty ()
{
	Destroy ();
}

void cMultiProperty::AllocateValue ( const cPropertyValue::eValueType type )
{
	cPropertyValue p ( type );
	m_values.push_back ( p );
	m_defaults.push_back ( p );	
}

cPropertyValue::eValueType	
cMultiProperty::Type ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].Type ();

	return m_values [ index ].Type ();
}

cPropertyValue::eValueType	
cMultiProperty::TypeDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].Type ();

	return m_defaults [ index ].Type ();
}

void cMultiProperty::Type ( const cPropertyValue::eValueType type, 
							const unsigned short index  ) 
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].Type ( type );
	}
	else
	{
		m_values [ index ].Type ( type );
	}
}

void cMultiProperty::TypeDefault ( const cPropertyValue::eValueType type, 
								   const unsigned short index  ) 
{
	if ( !IsValidDefaultIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].Type ( type );
	}
	else
	{
		m_defaults [ index ].Type ( type );
	}		
}

string cMultiProperty::Name () const
{
	return m_name;
}

void cMultiProperty::Name ( const string name )
{
	m_name = name;
}

string cMultiProperty::Info () const
{
	return m_info;
}

void cMultiProperty::Info ( const string info )
{
	m_info = info;
}

// values
bool cMultiProperty::GetBool ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetBool ();

	return m_values [ index ].GetBool ();
}

void cMultiProperty::SetBool ( const bool value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetBool ( value );
	}
	else
	{
		m_values [ index ].SetBool ( value );
	}
}

char cMultiProperty::GetChar ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetChar ();

	return m_values [ index ].GetChar ();
}

void cMultiProperty::SetChar ( const char value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetChar ( value );
	}
	else
	{
		m_values [ index ].SetChar ( value );
	}
}

short cMultiProperty::GetShort ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetShort ();

	return m_values [ index ].GetShort ();
}

void cMultiProperty::SetShort ( const short value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetShort ( value );
	}
	else
	{
		m_values [ index ].SetShort ( value );
	}
}

int cMultiProperty::GetInt ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetInt ();
	
	return m_values [ index ].GetInt ();
}

void cMultiProperty::SetInt ( const int value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetInt ( value );
	}
	else
	{
		m_values [ index ].SetInt ( value );
	}
}

long cMultiProperty::GetLong ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetLong ();

	return m_values [ index ].GetLong ();
}

void cMultiProperty::SetLong ( const long value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetLong ( value );
	}
	else
	{
		m_values [ index ].SetLong ( value );
	}
}

float cMultiProperty::GetFloat ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetFloat ();
	
	return m_values [ index ].GetFloat ();
}

void cMultiProperty::SetFloat ( const float value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetFloat ( value );
	}
	else
	{
		m_values [ index ].SetFloat ( value );
	}
}

double cMultiProperty::GetDouble ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetDouble ();

	return m_values [ index ].GetDouble ();
}

void cMultiProperty::SetDouble ( const double value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetDouble ( value );
	}
	else
	{
		m_values [ index ].SetDouble ( value );
	}
}

string cMultiProperty::GetString ( const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
		return m_values [ m_values.size () - 1 ].GetString ();

	return m_values [ index ].GetString ();
}

void cMultiProperty::SetString ( const string value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_values [ m_values.size () - 1 ].SetString ( value );
	}
	else
	{
		m_values [ index ].SetString ( value );
	}
}

// default values
bool cMultiProperty::GetBoolDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetBool ();

	return m_defaults [ index ].GetBool ();
}

void cMultiProperty::SetBoolDefault ( const bool value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetBool ( value );
	}
	else
	{
		m_defaults [ index ].SetBool ( value );
	}
}

char cMultiProperty::GetCharDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetChar ();

	return m_defaults [ index ].GetChar ();
}

void cMultiProperty::SetCharDefault ( const char value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetChar ( value );
	}
	else
	{
		m_defaults [ index ].SetChar ( value );
	}
}

short cMultiProperty::GetShortDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetShort ();

	return m_defaults [ index ].GetShort ();
}

void cMultiProperty::SetShortDefault ( const short value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetShort ( value );
	}
	else
	{
		m_defaults [ index ].SetShort ( value );
	}
}

int cMultiProperty::GetIntDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetInt ();

	return m_defaults [ index ].GetInt ();
}

void cMultiProperty::SetIntDefault ( const int value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetInt ( value );
	}
	else
	{
		m_defaults [ index ].SetInt ( value );
	}
}

long cMultiProperty::GetLongDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetLong ();

	return m_defaults [ index ].GetLong ();
}

void cMultiProperty::SetLongDefault ( const long value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetLong ( value );
	}
	else
	{
		m_defaults [ index ].SetLong ( value );
	}
}

float cMultiProperty::GetFloatDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetFloat ();

	return m_defaults [ index ].GetFloat ();
}

void cMultiProperty::SetFloatDefault ( const float value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetFloat ( value );
	}
	else
	{
		m_defaults [ index ].SetFloat ( value );
	}
}

double cMultiProperty::GetDoubleDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetDouble ();

	return m_defaults [ index ].GetDouble ();
}

void cMultiProperty::SetDoubleDefault ( const double value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetDouble ( value );
	}
	else
	{
		m_defaults [ index ].SetDouble ( value );
	}
}

string cMultiProperty::GetStringDefault ( const unsigned short index  )
{
	if ( !IsValidDefaultIndex ( index ) )
		return m_defaults [ m_defaults.size () - 1 ].GetString ();

	return m_defaults [ index ].GetString ();
}

void cMultiProperty::SetStringDefault ( const string value, const unsigned short index  )
{
	if ( !IsValidIndex ( index ) )
	{
		AllocateValue ();
		m_defaults [ m_defaults.size () - 1 ].SetString ( value );
	}
	else
	{
		m_defaults [ index ].SetString ( value );
	}
}

void cMultiProperty::Destroy ()
{
	// iterate through all the values and destroy them
	m_values.erase ( m_values.begin (), m_values.end () );
	m_defaults.erase ( m_defaults.begin (), m_defaults.end () );
	AllocateValue ();
}

bool cMultiProperty::IsValidIndex ( const unsigned short index ) const
{
	return ( index < m_values.size () );
}

bool cMultiProperty::IsValidDefaultIndex ( const unsigned short index ) const
{
	return ( index < m_defaults.size () );
}

unsigned int cMultiProperty::NumValues () const
{
	return m_values.size ();
}

void cMultiProperty::Clear ()
{
	unsigned int i = 0;

	for ( i = 0; i < m_values.size (); ++i )
		m_values [ i ].Clear ();

	for ( i = 0; i < m_defaults.size (); ++i )
		m_defaults [ i ].Clear ();
}
