/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
#include "ps_string_conv.hpp"

using std::stringstream;

stringstream cStringConverter::m_temp;

cStringConverter::cStringConverter ( string &s ) :
m_string ( &s )
{
}

cStringConverter::cStringConverter () :
m_string ( 0 )
{
}

cStringConverter::~cStringConverter ()
{
}


void cStringConverter::SetString ( string &string )
{
	m_string = &string;
}


bool cStringConverter::ToBool ()
{
	if ( !m_string )
		return false;

	if ( m_string->empty () )
		return false;

	if ( m_string->at ( 0 ) == '0' || *m_string == "false" )
		return false;

	if ( *m_string == "true" )
		return true;

	m_temp.str ( "" );
	bool val = false;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

char cStringConverter::ToChar ()
{
	if ( !m_string )
		return '\0';

	if ( m_string->empty () )
		return '\0';

	return m_string->at ( 0 );
}

short	cStringConverter::ToShort ()
{
	if ( !m_string )
		return 0;
	
	if ( m_string->empty () )
		return 0;

	m_temp.str ( "" );
	short val = 0;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

int cStringConverter::ToInt ()
{
	if ( !m_string )
		return 0;

	if ( m_string->empty () )
		return 0;

	m_temp.str ( "" );
	int val = 0;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

long	cStringConverter::ToLong ()
{
	if ( !m_string )
		return 0;

	if ( m_string->empty () )
		return 0;

	m_temp.str ( "" );
	long val = 0;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

float	cStringConverter::ToFloat ()
{
	if ( !m_string )
		return 0.0;

	if ( m_string->empty () )
		return 0.0;

	m_temp.str ( "" );
	float val = 0.0;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

double cStringConverter::ToDouble ()
{
	if ( !m_string )
		return 0.0;

	if ( m_string->empty () )
		return 0.0;

	m_temp.str ( "" );
	double val = 0.0;
	m_temp << *m_string;
	m_temp >> val;
	return val;
}

