/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
/*********************************************************************************************
*	Class:		cStringConverter
*
*	Purpose:	This class converts strings to values.
*				
*	Notes:		
*
*	This class attempts to convert a string to the requested value.
*
*	For bool, a value of "0" or "false" is considered false, 
*	any non-zero value or "true" is considered true.
*	For char, the first character of the string is returned or '\0' if empty.
*	For all other values, the value is converted or first character's
*	value is used, 0 if empty.			
*				
*	FIXME:	1. Add logging for conversions that don't make sense
*
*	Author:	Robert Farrell
*	Email:	farrellr@accis.edu
*
*	History:
*	12/18/2001	Initial version.
*********************************************************************************************/
#ifndef _STRING_CONVERTER_HPP
#define _STRING_CONVERTER_HPP

#include <sstream>

using std::stringstream;
using std::string;

class cStringConverter
{
public:
	cStringConverter ( string &s );
	cStringConverter ();
	virtual ~cStringConverter ();

	void	SetString ( string &s );

	bool	ToBool ();
	char	ToChar ();
	short	ToShort ();
	int		ToInt ();
	long	ToLong ();
	float	ToFloat ();
	double	ToDouble ();

private:
	string *			m_string;
	static stringstream	m_temp;
};
#endif // _STRING_CONVERTER_HPP
