/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
#include "ps_value.hpp"

using std::stringstream;

cStringConverter cPropertyValue::m_conv;

cPropertyValue::cPropertyValue (	const eValueType type )
{
	Type ( type );
}

cPropertyValue::cPropertyValue () :
m_type ( PV_NONE )
{
	m_value.bool_val	= 0;
	m_value.double_val	= 0;
	m_value.float_val	= 0;
}

cPropertyValue::~cPropertyValue ()
{
}

cPropertyValue::eValueType cPropertyValue::Type () const
{
	return m_type;
}

void cPropertyValue::Type ( const eValueType type )
{
	if ( !IsValidType ( type ) )
	{
		cInvalidValueType e ( "Error: Invalid type sent to cPropertyValue::Type ()" );
		throw e;
	}

	m_type = type;
}

bool cPropertyValue::IsValidType ( const eValueType type )
{
	switch ( type )
	{
		case PV_BOOL:
		case PV_CHAR:
		case PV_SHORT:
		case PV_INT:
		case PV_LONG:
		case PV_FLOAT:
		case PV_DOUBLE:
		case PV_STRING:
		case PV_NONE:	return true;

		default: return false;
	}
}

bool cPropertyValue::GetBool ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToBool ();
	}
	else
	{
		return m_value.bool_val;
	}
}

void cPropertyValue::SetBool ( const bool value )
{
	Type ( PV_BOOL );
	m_value.bool_val = value;
}

char cPropertyValue::GetChar ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToChar ();
	}
	else
	{
		return m_value.char_val;
	}
}

void cPropertyValue::SetChar ( const char value )
{
	Type ( PV_CHAR );
	m_value.char_val = value;
}

short cPropertyValue::GetShort ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToShort ();
	}
	else
	{
		return m_value.short_val;
	}
}

void cPropertyValue::SetShort ( const short value )
{
	Type ( PV_SHORT );
	m_value.short_val = value;
}

int cPropertyValue::GetInt ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToInt ();
	}
	else
	{
		return m_value.int_val;
	}
}

void cPropertyValue::SetInt ( const int value )
{
	Type ( PV_INT );
	m_value.int_val = value;
}

long cPropertyValue::GetLong ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToLong ();
	}
	else
	{
		return m_value.long_val;
	}
}

void cPropertyValue::SetLong ( const long value )
{
	Type ( PV_LONG );
	m_value.long_val = value;
}

float cPropertyValue::GetFloat ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToFloat ();
	}
	else
	{
		return m_value.float_val;
	}
}

void cPropertyValue::SetFloat ( const float value )
{
	Type ( PV_FLOAT );
	m_value.float_val = value;
}

double cPropertyValue::GetDouble ()
{
	if ( m_type == PV_STRING )
	{
		m_conv.SetString ( m_string );
		return m_conv.ToDouble ();
	}
	else
	{
		return m_value.double_val;
	}
}

void cPropertyValue::SetDouble ( const double value )
{
	Type ( PV_DOUBLE );
	m_value.double_val = value;
}

string cPropertyValue::GetString ()
{
	if ( m_type == PV_STRING )
	{
		return m_string;
	}
	else
	{		
		// convert the value
		stringstream temp;
		temp.str ( "" );

		switch ( m_type )
		{
			case PV_BOOL:	temp << m_value.bool_val;		break;
			case PV_CHAR:	temp << m_value.char_val;		break;
			case PV_SHORT:	temp << m_value.short_val;		break;
			case PV_INT:	temp << m_value.int_val;		break;
			case PV_LONG:	temp << m_value.long_val;		break;
			case PV_FLOAT:	temp << m_value.float_val;		break;
			case PV_DOUBLE:	temp << m_value.double_val;	break;
			case PV_NONE:	return m_string;
			
			default: break;		
		}

		return temp.str ();
	}
}

void cPropertyValue::SetString ( const string value )
{
	Type ( PV_STRING );
	m_string = value;
}

void cPropertyValue::Clear ()
{
	Type ( PV_NONE );
	m_string = "";
	m_value.bool_val	= 0;
	m_value.double_val	= 0;
	m_value.float_val	= 0;
}

cPropertyValue::cInvalidValueType::cInvalidValueType ( string msg ) :
cPropertyException ( msg )
{
}

