/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
/*********************************************************************************************
*	Class:		cPropertyValue
*
*	Purpose:	This class stores a type and value.
*				
*	Notes:		
*
*	This class offers type conversion from strings to values, and values to strings. 
*	The type changes if Type () is called, or if a Set* () member function is called.
*	When Get* () is called, a value conversion is performed but the type
*	remains unchanged.
*	This class uses cStringConverter for converting strings to values.
*
*	Author:	Robert Farrell
*	Email:	farrellr@accis.edu
*
*	History:
*	12/18/2001	Initial version.
*********************************************************************************************/
#ifndef _PROPERTY_VALUE_HPP
#define _PROPERTY_VALUE_HPP

#include "ps_exception.hpp"
#include "ps_string_conv.hpp"
#include <string>

using std::string;

class cPropertyValue
{
public:
	typedef union property_value 
	{
		bool	bool_val;
		char	char_val;
		short	short_val;
		int		int_val;
		long	long_val;
		float	float_val;
		double	double_val;
	} property_value_t;

	enum eValueType {	PV_BOOL,
						PV_CHAR,
						PV_SHORT,
						PV_INT,
						PV_LONG,
						PV_FLOAT,
						PV_DOUBLE,
						PV_STRING,
						PV_NONE };

	// Exceptions
	class cInvalidValueType;

	cPropertyValue ( const eValueType type );
	cPropertyValue ();
	virtual ~cPropertyValue ();

	eValueType	Type () const;
	void		Type ( const eValueType type );
	
	bool	GetBool ();
	void	SetBool ( const bool value );
	char	GetChar ();
	void	SetChar ( const char value );
	short	GetShort ();
	void	SetShort ( const short value );
	int		GetInt ();
	void	SetInt ( const int value );
	long	GetLong ();
	void	SetLong ( const long value );
	float	GetFloat ();
	void	SetFloat ( const float value );
	double	GetDouble ();
	void	SetDouble ( const double value );
	string	GetString ();
	void	SetString ( const string value );

	// sets type to PV_NONE, empty string, 0 for all values
	void	Clear ();

private:
	bool	IsValidType ( const eValueType type );

private:
	eValueType				m_type;
	property_value_t		m_value;
	string					m_string;
	static cStringConverter	m_conv;
};

class cPropertyValue::cInvalidValueType : public cPropertyException
{
public:
	cInvalidValueType ( string msg );
};
#endif // _PROPERTY_VALUE_HPP
