/*********************************************************************************************
*	Copyright (C) 2002 Robert Farrell
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*
*	See the GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
**********************************************************************************************/
/*********************************************************************************************
*	Class:		cPropertySetWriter
*
*	Purpose:	This class writes a cPropertySet to a file stream.
*				
*	Notes:		This class assumes that any info that is associated with a key
*				is stored as key=key name, param=key name.
*
*				An example file is the following:
*				
*				# This is a comment
*				# This makes it a multi-line comment
*				# One more line just for kicks
*
*				# All info will be associated with the following key
*				[ First Key ]
*
*				# This info is associated with this param
*				param = foo
*
*				# This is a multi-valued param
*				param1 = foo; bar; baz
*
*				# Multi value params can have emtpy values, just put in extra ;'s
*				# This one has eight values
*				param2 = ; two;; four;; six; ;
*
*				# Any info that is not before a param or key will be lost
*				# That includes these lines
*				# Any key without parameters will be lost
*
*				This class does not write empty info, key, or param strings.
*				This class does not write any default values for any parameters.
*
*	Author:	Robert Farrell
*	Email:	farrellr@accis.edu
*
*	History:
*	12/18/2001	Initial version.
*	1/8/2002	Fixed bug when key had info but no parameters, blank param was written.
*	1/8/2002	Key delimiters are now written in this class.
*	1/8/2002	Info start delimiters are now written in this class.
*********************************************************************************************/
#ifndef _PROPERTY_SET_WRITER_HPP
#define _PROPERTY_SET_WRITER_HPP

#include "ps_property_set.hpp"
#include <fstream>

using std::fstream;

class cPropertySetWriter
{
public:
	cPropertySetWriter ( cPropertySet &ps );
	virtual ~cPropertySetWriter ();

	void Write ();

private:
	void WriteKey ( const string &key );
	void WriteInfo ( const string &info );
	void WriteParam ( const string &name );
	void WriteMultiProperty ( cMultiProperty &p );

	// no copying is allowed
	cPropertySetWriter ( const cPropertySetWriter & );
	cPropertySetWriter & operator= ( const cPropertySetWriter & );

private:
	cPropertySet *	m_property_set;
	fstream			m_out;
	const char		M_INFO_START;
	const char		M_KEY_START;
	const char		M_KEY_END;
	const char		M_LINE_END;
	const char		M_ASSIGN;
	const char		M_MULTI_VALUE;
};
#endif // _PROPERTY_SET_WRITER_HPP
