//------------------------------------------------------------------------------
// (c) 2001 Gottfried Chen
//------------------------------------------------------------------------------

namespace zip
{

template<class C, class T>
//------------------------------------------------------------------------------
basic_izipstream<C, T>::basic_izipstream(izipfile& zip,
                                         const char* fileName,
                                         std::ios_base::openmode mode) :
//------------------------------------------------------------------------------
std::basic_istream<C, T>(0)
{
    open(zip, fileName, mode);
}

template<class C, class T>
//------------------------------------------------------------------------------
void basic_izipstream<C, T>::open(izipfile& zip, const char* fileName,
                                  std::ios_base::openmode mode)
//------------------------------------------------------------------------------
{
    close();

    mBuffer.open(zip, fileName, mode);
    if (mBuffer.is_open())
        init(&mBuffer);
    else
        setstate(std::ios_base::failbit);
}

template<class C, class T>
//------------------------------------------------------------------------------
void basic_izipstream<C, T>::close()
//------------------------------------------------------------------------------
{
    mBuffer.close();
    init(0);
}

} // namespace zip