#include "../zip/zipstream.h"
#include <iostream>
#include <string>

void test()
{
    using namespace zip;
    using namespace std;

    //-----------
    // Test output
    //-----------

    ozipfile out("test.zip");
    ozipstream oasc(out, "test.txt");
    oasc<<123<<endl;
    oasc<<"hello"<<endl;
    oasc<<3.14f<<endl;
    // Close file in zip, since only one concurrent file allowed.
    oasc.close();
    
    ozipstream obin(out, "data/test.bin", ios_base::out|ios_base::binary);
    //obin<<"s";

    char othree[100];
    memset(othree, 3, 100);
    obin.write(othree, 100);
    obin.close();

    // Close zip, so that it can be reopened.
    out.close();

    //-----------
    // Test input
    //-----------

    izipfile in("test.zip");
    izipstream iasc(in, "test.txt");
    int a;
    string b;
    float c;
    iasc>>a;
    cout<<a<<endl;
    iasc>>b;
    cout<<b<<endl;
    iasc>>c;
    cout<<c<<endl;
    // Close file in zip, since only one concurrent file allowed.
    iasc.close();
    
    izipstream ibin(in, "data/test.bin", ios_base::in|ios_base::binary);
    char ithree[100];
    ibin.read(ithree, 100);
    if (memcmp(othree, ithree, 100) == 0)
        cout<<"Buffers are equal\n";
    else
        cout<<"Buffers don't match\n";
    
    // Destructor closes rest.
}

int main()
{
    test();
    return 0;
}
