;
;                           The Art Of
;                       D E M O M A K I N G
;
;
;                      by Alex J. Champandard
;                           Base Sixteen
;
;
;                 http://www.flipcode.com/demomaking
;
;                 This file is in the public domain.
;                       Use at your own risk.
;
;
;             Compile with NASM:    nasm -fcoff draw.asm



[BITS 32]

;
; export our procedure
;
[GLOBAL _Draw_Hole__FPUcUcUc]

;
; declare external variables
;
[EXTERN _texdata]                              ; buffer with texture
[EXTERN _texcoord]                             ; buffer with (u,v) coords

;
; local vars, unused in this program
;
[SECTION .data]

exampleVar dd      00000000h


;
; CODE
;
[SECTION .text]

; the parameters for our function
p_buf           equ 8                         ; buffer to draw into
p_du            equ 12                        ; u delta offset
p_dv            equ 16                        ; v delta offset


;
; void Draw_Hole( unsigned char *buf, unsigned char du, unsigned char dv );
;
_Draw_Hole__FPUcUcUc

        push ebp                               ; save ebp for later
        mov  ebp, esp                          ; get the address of the stack

        pushad                                 ; save all other registers

        mov  edi, dword [ebp+p_buf]            ; load destination pointer
        mov  esi, dword [_texcoord]            ; get pointer to coord buffer
        mov  ebx, dword [_texdata]             ; get texture pointer
        mov  dl, byte [ebp+p_du]               ; load u delta into dl
        mov  dh, byte [ebp+p_dv]               ; load v delta into dl

        mov  ecx, 64000                        ; setup our loop counter

.L
        mov  bx, [esi]                         ; load (u,v) in bx
        add  bl, dl                            ; u += du
        add  bh, dh                            ; v += dv
        mov  al, [ebx]                         ; load texel
        mov  [edi], al                         ; store pixel
        add  esi, 2                            ; next location in coord buffer
        inc  edi                               ; inc destination pointer
        dec  ecx                               ; decrement counter
        jnz  .L                                ; exit loop if counter is null

        popad                                  ; restore all other registers
        pop ebp                                ; restore ebp

        ret                                    ; and return

